using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.GUI;
using CONTROLS = gov.va.med.vbecs.GUI.controls;
using System.Text.RegularExpressions;
using System.Text;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// TabActivatedEventHandler
	/// </summary>
	public delegate void TabActivatedEventHandler(object sender, EventArgs e, int reagentTypeID, string reagentTypeName);

	/// <summary>
	/// Summary description for AntigenTypingWeakD.
	/// </summary>
	public class AntigenTypingWeakD : System.Windows.Forms.Panel
	{
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.DataGridTableStyle _dgAntigenTypingTableStyle;
		private System.Windows.Forms.DataGridTextBoxColumn _dcTextBox;
		private controls.DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		private gov.va.med.vbecs.GUI.controls.VbecsDataGrid dgAntigenTyping;
		private DataTable _dtAGT;
		private controls.ComboBoxLookup cmbBox;
		private controls.ComboBoxLookup cmbBoxComment;
		private BOL.Division _division;
		private string _validEntries;
		private Common.TestingMethod _testMethod;
		private DataTable _dtReagents;
		private int _activeAntisera;
		private DateTime _testingDateTime;
		private int _reactivityPhase;
		string _lastErrorMessage;
		private string _testingTech;
		private bool _keyPressEventHandled; //CR 2792

		/// <summary>
		/// CellChanged Event
		/// </summary>
		public event CellChangedEventHandler CellChanged;

		/// <summary>
		/// TabActivated Event
		/// </summary>
		public event TabActivatedEventHandler TabActivated;

		/// <summary>
		/// enableInvalidation
		/// </summary>
		public bool enableInvalidation;

		/// <summary>
		/// DataSourceTables
		/// </summary>
		public ArrayList DataSourceTables;

		/// <summary>
		/// TabRemoved
		/// </summary>
		public bool TabRemoved;

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public AntigenTypingWeakD()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			DataSourceTables = new ArrayList();
			_activeAntisera = 0;
			_lastErrorMessage = string.Empty;
			TabRemoved = false;
						
			//I put this try/catch just to make this control appear on the UC_56 main windows in the design view
			try
			{
				this._division = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
			}
			catch{}

			InitializeGrid();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(AntigenTypingWeakD));
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.cmbBox = new controls.ComboBoxLookup();
			this.cmbBoxComment = new controls.ComboBoxLookup();
			this.btnClear = new System.Windows.Forms.Button();
			this.dgAntigenTyping = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.tabControl1.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.dgAntigenTyping)).BeginInit();
			this.SuspendLayout();
			// 
			// tabControl1
			// 
			this.tabControl1.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.tabControl1.Multiline = true;
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.Size = new System.Drawing.Size(568, 128);
			this.tabControl1.TabIndex = 93;
			this.tabControl1.SelectedIndexChanged += new System.EventHandler(this.pageAntisera_SelectedIndexChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnClear.Image = ((System.Drawing.Bitmap)(resources.GetObject("btnClear.Image")));
			this.btnClear.Location = new System.Drawing.Point(544, 24);
			this.btnClear.Name = "btnClear";
			this.btnClear.Size = new System.Drawing.Size(20, 20);
			this.btnClear.TabIndex = 95;
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// cmbBox
			// 
			this.cmbBox.MaxLength = 15;
			this.cmbBox.Name = "cmbBox";
			this.cmbBox.TabIndex = 0;
			this.cmbBox.Width = 98;
			this.cmbBox.SelectedIndexChanged += new System.EventHandler(this.cmbBox_SelectedIndexChanged);
			this.cmbBox.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBox_Validating);
			// 
			// cmbBoxComment
			// 
			this.cmbBoxComment.MaxLength = 255;
			this.cmbBoxComment.Name = "cmbBoxComment";
			this.cmbBoxComment.TabIndex = 0;
			this.cmbBoxComment.Width = 288;
			this.cmbBoxComment.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBoxComment_Validating);
			// 
			// dgAntigenTyping
			// 
			this.dgAntigenTyping.AllowSorting = false;
			this.dgAntigenTyping.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.dgAntigenTyping.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgAntigenTyping.CaptionText = "Patient Antigen Typing";
			this.dgAntigenTyping.CaptionVisible = false;
			this.dgAntigenTyping.DataMember = string.Empty;
			this.dgAntigenTyping.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgAntigenTyping.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgAntigenTyping.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgAntigenTyping.Location = new System.Drawing.Point(4, 24);
			this.dgAntigenTyping.Name = "dgAntigenTyping";
			this.dgAntigenTyping.RowHeadersVisible = false;
			this.dgAntigenTyping.Size = new System.Drawing.Size(560, 100);
			this.dgAntigenTyping.TabIndex = 94;
			this.dgAntigenTyping.ToolTipColumn = -1;
			this.dgAntigenTyping.CurrentCellChanged += new System.EventHandler(this.dgAntigenTyping_CurrentCellChanged);
			// 
			// AntigenTypingWeakD
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnClear,
																		  this.dgAntigenTyping,
																		  this.tabControl1});
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "AntigenTypingWeakD";
			this.Size = new System.Drawing.Size(568, 128);
			this.tabControl1.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.dgAntigenTyping)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Invoke tab activated event
		/// </summary>
		/// <param name="reagentTypeID"></param>
		/// <param name="reagentTypeName"></param>
		protected virtual void OnTabActivated(int reagentTypeID, string reagentTypeName)
		{
			if (TabActivated != null)
				TabActivated(this, EventArgs.Empty, reagentTypeID, reagentTypeName);
		}

		/// <summary>
		/// Initialize the grid and set the grid style
		/// </summary>
		private void InitializeGrid()
		{
			this.dgAntigenTyping.CaptionVisible = true;
			this.dgAntigenTyping.Enter += new System.EventHandler(dgAntigenTyping_Enter);
			this.dgAntigenTyping.Leave += new EventHandler(dgAntigenTyping_Leave);
			this.dgAntigenTyping.LostFocus +=new EventHandler(dgAntigenTyping_LostFocus);
			this.dgAntigenTyping.SizeChanged+=new EventHandler(dgAntigenTyping_SizeChanged);
			this.dgAntigenTyping.NextCell+=new controls.NextCellEventHandler(SetNextCell);
			//
			AddAGTCustomDataTableStyle();
			this._keyPressEventHandled = false; //CR 2792
		}

		/// <summary>
		/// Add the Tab control for the antisera
		/// </summary>
		/// <param name="AntiseraName"></param>
		/// <param name="Test"></param>
		private void AddAntigenTab(string AntiseraName, BOL.OrderedTest Test)
		{
			System.Windows.Forms.TabPage pageAntisera;
			pageAntisera = new System.Windows.Forms.TabPage();
			pageAntisera.Tag = Test;
			this.tabControl1.TabPages.Add(pageAntisera);

			AntiseraName = AntiseraName.Replace("AG", string.Empty);
			if (AntiseraName == "wD")
				AntiseraName = "Weak D";

			pageAntisera.Location = new System.Drawing.Point(4, 23);
			pageAntisera.Name = AntiseraName;
			pageAntisera.Size = new System.Drawing.Size(560, 101);
			pageAntisera.TabIndex = 0;
			pageAntisera.Text = AntiseraName;
		}

		/// <summary>
		/// Set or get the division code
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._division.DivisionCode;
			}
			set
			{
				if (value != null)
				{
					this._division = new BOL.Division(value);
				}
			}
		}

		/// <summary>
		/// Get the valid entries description for grid cell
		/// </summary>
		public string ValidEntries
		{
			get
			{
				return this._validEntries;
			}
		}

		/// <summary>
		/// Get or set the test method
		/// </summary>
		public Common.TestingMethod TestMethod
		{
			get
			{
				return this._testMethod;
			}
			set
			{
				this._testMethod = value;
			}
		}

		/// <summary>
		/// Get or set the testing tech
		/// </summary>
		public string TestingTech
		{
			get
			{
				return this._testingTech;
			}
			set
			{
				this._testingTech = value;
			}
		}

		/// <summary>
		/// Get or set the LotNumber
		/// </summary>
		public string LotNumber
		{
			get
			{
				int row = this.dgAntigenTyping.CurrentCell.RowNumber;
				if (this._dtAGT.Rows[row].IsNull(TABLE.Reagent.LotNumber) == false)
					return this._dtAGT.Rows[row][TABLE.Reagent.LotNumber].ToString();
				else
					return string.Empty;
			}

			set
			{
				this._dtAGT.Rows[0][TABLE.Reagent.LotNumber] = value;
			}
		}

		/// <summary>
		/// Get or set the expiration date
		/// </summary>
		public DateTime ExpirationDate
		{
			get
			{
				int row = this.dgAntigenTyping.CurrentCell.RowNumber;
				if (this._dtAGT.Rows[row].IsNull(TABLE.ExceptionExpiredUnitReceived.ExpirationDate) == false)
					return (DateTime)this._dtAGT.Rows[row][TABLE.ExceptionExpiredUnitReceived.ExpirationDate];
				else
					return DateTime.MinValue;
			}
	
			set
			{
				this._dtAGT.Rows[0][TABLE.ExceptionExpiredUnitReceived.ExpirationDate] = value;
			}
		}

		/// <summary>
		/// Get or set the manufacturer
		/// </summary>
		public string Manufacturer
		{
			get
			{
				int row = this.dgAntigenTyping.CurrentCell.RowNumber;
				if (this._dtAGT.Rows[row].IsNull(ARTIFICIAL.Manufacturer) == false)
					return this._dtAGT.Rows[row][ARTIFICIAL.Manufacturer].ToString();
				else
					return string.Empty;
			}
		
			set
			{
				this._dtAGT.Rows[0][ARTIFICIAL.Manufacturer] = value;
			}
		}

		/// <summary>
		/// Set the expired antisera exception
		/// </summary>
		public BOL.ExceptionReport ExpiredAntiseraException
		{
			set
			{
				this._dtAGT.Rows[0][ARTIFICIAL.ReagentExpiredException] = value;
			}
		}

		/// <summary>
		/// Set the RegentGUID that is being tested
		/// </summary>
		public Guid ReagentGuid
		{
			get
			{
				int row = this.dgAntigenTyping.CurrentCell.RowNumber;
				if (this._dtAGT.Rows[row].IsNull(TABLE.Reagent.ReagentGuid) == false)
					return (Guid)this._dtAGT.Rows[row][TABLE.Reagent.ReagentGuid];
				else
					return Guid.Empty;
			}

			set
			{
				this._dtAGT.Rows[0][TABLE.Reagent.ReagentGuid] = value;
	
				if (System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.AGwD &&
					System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.RepeatAGwD)
				{
					//if the reagent was not QCd add two QC rows to the grid
					DataTable dtReagentTestResults = BOL.RackTest.GetReagentTestResult(this.DivisionCode, (Guid)this._dtAGT.Rows[0][TABLE.Reagent.ReagentGuid], this.TestingDateTime, Convert.ToChar(this.ReactivityPhase.ToString()));
					if (dtReagentTestResults.Rows.Count == 0 && this._dtAGT.Rows.Count == 1)
					{
						this.AddRemoveQCRowsToDataGrid(true);
					}
				}
			}
		}

		/// <summary>
		/// Set PhaseChangedComment
		/// </summary>
		public string PhaseChangedComment
		{
			set
			{
				if (value != string.Empty)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Antigen_testing_phase_change, value, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionPatientTest(this.ActiveOrder, Common.Utility.GetReactivityPhaseTextFromCode(this.ReactivityPhase.ToString()), string.Empty, this._testingDateTime, this._testingTech);
					this._dtAGT.Rows[0][ARTIFICIAL.PhaseChangedException] = exRep;
				}
			}
		}

		/// <summary>
		/// Return the reagent type of the patient testing row
		/// </summary>
		public BOL.Reagent Reagent
		{
			get
			{
				int row = 0;

				if (this._dtAGT.Rows.Count == 3)
					row = 2;

				BOL.Reagent reagent = new BOL.Reagent();
				reagent.ReagentType.ReagentTypeId = (int)this._dtAGT.Rows[row][TABLE.Reagent.ReagentTypeId];
				reagent.ReagentType.ReagentTypeName = this._dtAGT.Rows[row][TABLE.ReagentType.ReagentTypeName].ToString();
				if (this._dtAGT.Rows[row].IsNull(TABLE.Reagent.ReagentGuid))
					reagent.ReagentGuid = Guid.Empty;
				else
					reagent.ReagentGuid = (Guid)this._dtAGT.Rows[row][TABLE.Reagent.ReagentGuid];

				return reagent;
			}
		}

		/// <summary>
		/// Set the phase of reactivity code
		/// </summary>
		public int ReactivityPhase
		{
			get
			{
					return this._reactivityPhase;
			}

			set
			{
				this._reactivityPhase = value;
				if (this._dtAGT != null)
				{
					foreach(DataRow dr in this._dtAGT.Rows)
					{
						dr[TABLE.BloodUnitTest.ReactivityPhaseCode] = this._reactivityPhase;
						switch(this._reactivityPhase)
						{
							case 1: //IS
								dr[ARTIFICIAL.ISSave] = true;
								dr[ARTIFICIAL.RTSave] = false;
								dr[ARTIFICIAL.C37Save] = false;
								dr[ARTIFICIAL.AHGSave] = false;
								dr[ARTIFICIAL.CCSave] = false;
								break;
							case 5: //IS/37
								dr[ARTIFICIAL.ISSave] = true;
								dr[ARTIFICIAL.RTSave] = false;
								dr[ARTIFICIAL.C37Save] = true;
								dr[ARTIFICIAL.AHGSave] = false;
								dr[ARTIFICIAL.CCSave] = false;
								break;
							case 4: //IS/RT
								dr[ARTIFICIAL.ISSave] = true;
								dr[ARTIFICIAL.RTSave] = true;
								dr[ARTIFICIAL.C37Save] = false;
								dr[ARTIFICIAL.AHGSave] = false;
								dr[ARTIFICIAL.CCSave] = false;
								break;
							case 6: //AHG/CC
								dr[ARTIFICIAL.ISSave] = false;
								dr[ARTIFICIAL.RTSave] = false;
								dr[ARTIFICIAL.C37Save] = false;
								dr[ARTIFICIAL.AHGSave] = true;
								dr[ARTIFICIAL.CCSave] = true;
								break;
						}
					}
				}
			}
		}

		/// <summary>
		/// Get ActiveOrder
		/// </summary>
		public BOL.OrderedTest ActiveOrder
		{
			get
			{
				if (this.tabControl1.TabPages.Count > 0)
					return (BOL.OrderedTest)this.tabControl1.TabPages[this._activeAntisera].Tag;
				else
					return null;
			}
		}

		/// <summary>
		/// Get/Set TestingDateTime
		/// </summary>
		public DateTime TestingDateTime
		{
			get
			{
				return this._testingDateTime;
			}
			set
			{
				this._testingDateTime = value;
			}
		}

		/// <summary>
		/// Get the name of the qc rack
		/// </summary>
		public string RackName
		{
			get
			{
				if (this._dtAGT.Rows[0].IsNull(TABLE.Rack.RackGuid) == false)
				{
					BOL.Rack rack = new BOL.Rack((Guid)this._dtAGT.Rows[0][TABLE.Rack.RackGuid]);
					return rack.RackName;
				}
				else
					return string.Empty;
			}
		}

		/// <summary>
		/// Invoke cell changed event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnCellChanged(System.EventArgs e)
		{
			if (CellChanged != null)
				CellChanged(this.dgAntigenTyping, e);
		}

		/// <summary>
		/// Created the antigen typing table that is used as a datasource for the datagrid
		/// </summary>
		/// <returns></returns>
		public DataTable CreateAgtTable(BOL.OrderedTest test, Guid rackGuid)
		{
			DataTable dt;
			int NumberOfTestingRows = 1;
			bool WeakDTyping = false;

			if (test.OrderableTestId == (int)Common.OrderableTest.AGwD ||
				test.OrderableTestId == (int)Common.OrderableTest.RepeatAGwD)
			{
				WeakDTyping = true;
			}

			dt = new System.Data.DataTable(test.OrderableTest.Replace("Repeat", string.Empty).Trim());

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add(ARTIFICIAL.TestType, typeof(string));
			dt.Columns.Add(TABLE.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.VialId);
			dt.Columns.Add(ARTIFICIAL.IS, typeof(string));
			dt.Columns.Add(ARTIFICIAL.RT, typeof(string));
			dt.Columns.Add(ARTIFICIAL.C37, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Interp, typeof(string));
			dt.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dt.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLE.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.ReagentType.ReagentTypeId, typeof(int));
			dt.Columns.Add(TABLE.ReagentType.ReagentTypeName);
			dt.Columns.Add(ARTIFICIAL.Manufacturer, typeof(string));
			dt.Columns.Add(TABLE.ExceptionExpiredUnitReceived.ExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLE.OrderableTest.OrderableTestId);
			dt.Columns.Add(TABLE.ValidRhResult.SystemInterp, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.LotNumberSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.VialIdSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.RTGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.RTRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.InterpRowVersion, typeof(byte[]));
			dt.Columns.Add(TABLE.BloodUnitTest.ReactivityPhaseCode, typeof(int));
			dt.Columns.Add(TABLE.OrderedTest.CprsOrderNumber);
			dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion,typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.ReagentExpiredException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.DiscrepantTypingException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.PhaseChangedException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(TABLE.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dt.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage);

			DataTable dtDailyQCReagentTypes = BOL.ReagentType.GetDailyQCReagentTypes(this._division.DivisionCode);

			//D control has been tested therefore it has to be used for WeakD testing
			if (WeakDTyping == true)
			{
				if (dtDailyQCReagentTypes.Select("ReagentTypeId = " + (int)Common.WeakDTestReagents.AntiDControl).Length > 0)
				{
					NumberOfTestingRows = 2;
				}
			}

			for (int i=0; i<NumberOfTestingRows; i++)
			{
				DataRow dr = dt.NewRow();
				dr[TABLE.Patient.PatientGuid] = test.Patient.PatientGuid;
				dr[TABLE.PatientSpecimen.PatientSpecimenGuid] = test.Specimen.SpecimenGuid;
				dr[TABLE.OrderedTest.OrderedTestGuid] = test.OrderedTestGuid;
				dr[TABLE.OrderableTest.OrderableTestId] = test.OrderableTestId;
				dr[ARTIFICIAL.OrderedTestRowVersion] = test.RowVersion;
				dr[ARTIFICIAL.Indicator] = string.Empty;

				if (test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					dr[TABLE.Reagent.LotNumber] = DBNull.Value;
					dr[ARTIFICIAL.VialId] = DBNull.Value;
					dr[ARTIFICIAL.IS] = DBNull.Value;
					dr[ARTIFICIAL.RT] = DBNull.Value;
					dr[ARTIFICIAL.C37] = DBNull.Value;
					dr[ARTIFICIAL.AHG] = DBNull.Value;
					dr[ARTIFICIAL.CC] = DBNull.Value;
					dr[ARTIFICIAL.LotNumberSave] = false;
					dr[ARTIFICIAL.VialIdSave] = false;
					dr[ARTIFICIAL.ISSave] = false;
					dr[ARTIFICIAL.RTSave] = false;
					dr[ARTIFICIAL.C37Save] = false;
					dr[ARTIFICIAL.AHGSave] = false;
					dr[ARTIFICIAL.CCSave] = false;
				}
				else
				{
					if (this._division.ServiceTypeIndicator == true)
					{
						dr[TABLE.Reagent.LotNumber] = string.Empty;
						dr[ARTIFICIAL.VialId] = DBNull.Value;
						dr[ARTIFICIAL.IS] = string.Empty;
						dr[ARTIFICIAL.RT] = string.Empty;
						dr[ARTIFICIAL.C37] = string.Empty;
						dr[ARTIFICIAL.AHG] = string.Empty;
						dr[ARTIFICIAL.CC] = string.Empty;
						dr[ARTIFICIAL.LotNumberSave] = true;
						dr[ARTIFICIAL.VialIdSave] = false;
						dr[ARTIFICIAL.ISSave] = true;
						dr[ARTIFICIAL.RTSave] = true;
						dr[ARTIFICIAL.C37Save] = true;
						dr[ARTIFICIAL.AHGSave] = true;
						dr[ARTIFICIAL.CCSave] = true;
					}
					else //Transfusion-Only
					{
						dr[TABLE.Reagent.LotNumber] = DBNull.Value;
						dr[ARTIFICIAL.VialId] = DBNull.Value;
						dr[ARTIFICIAL.IS] = DBNull.Value;
						dr[ARTIFICIAL.RT] = DBNull.Value;
						dr[ARTIFICIAL.C37] = DBNull.Value;
						dr[ARTIFICIAL.AHG] = DBNull.Value;
						dr[ARTIFICIAL.CC] = DBNull.Value;
						dr[ARTIFICIAL.LotNumberSave] = false;
						dr[ARTIFICIAL.VialIdSave] = false;
						dr[ARTIFICIAL.ISSave] = false;
						dr[ARTIFICIAL.RTSave] = false;
						dr[ARTIFICIAL.C37Save] = false;
						dr[ARTIFICIAL.AHGSave] = false;
						dr[ARTIFICIAL.CCSave] = false;
					}
				}

				dr[ARTIFICIAL.Interp] = string.Empty;
				dr[ARTIFICIAL.Comment] = string.Empty;
				dr[ARTIFICIAL.InterpSave] = true;
				dr[ARTIFICIAL.PartiallyCompleted] = false;
				dr[TABLE.OrderedTest.CprsOrderNumber] = test.CPRSOrderNumber;
				if (test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
					dr[TABLE.SpecimenTest.CorrectedResultIndicator] = true;
				else
					dr[TABLE.SpecimenTest.CorrectedResultIndicator] = false;

				dr[ARTIFICIAL.IndicatorMessage] = string.Empty;

				if (rackGuid != Guid.Empty)
					dr[TABLE.Rack.RackGuid] = rackGuid;

				if (WeakDTyping == true)
				{
					if (i==0)
					{
						dr[ARTIFICIAL.TestType] = "Anti-D";
						dr[TABLE.ReagentType.ReagentTypeName] = test.GetReagentTypeForOrderableTest().ReagentTypeName;
						dr[TABLE.ReagentType.ReagentTypeId] = test.GetReagentTypeForOrderableTest().ReagentTypeId;
					}
					else if (i==1)
					{
						DataTable dtReagentTypes = BOL.ReagentType.GetReagentTypes();
						dr[ARTIFICIAL.TestType] = "Anti-D Control";
						dr[TABLE.ReagentType.ReagentTypeName] = dtReagentTypes.Select(TABLE.ReagentType.ReagentTypeId + " = " + (int)Common.WeakDTestReagents.AntiDControl)[0][TABLE.ReagentType.ReagentTypeName];
						dr[TABLE.ReagentType.ReagentTypeId] = (int)Common.WeakDTestReagents.AntiDControl;
						dr[ARTIFICIAL.InterpSave] = false;
						dr[ARTIFICIAL.Interp] = DBNull.Value;
						dr[ARTIFICIAL.Comment] = string.Empty;
					}
					dr[ARTIFICIAL.ISSave] = false;
					dr[ARTIFICIAL.RTSave] = false;
					dr[TABLE.BloodUnitTest.ReactivityPhaseCode] = Common.ReactivityPhase.ThreeSevenandAHG;
					this._reactivityPhase = (int)Common.ReactivityPhase.ThreeSevenandAHG;
				}
				else
				{
					dr[ARTIFICIAL.TestType] = "Patient";
					dr[TABLE.ReagentType.ReagentTypeId] = test.GetReagentTypeForOrderableTest().ReagentTypeId;
					dr[TABLE.ReagentType.ReagentTypeName] = test.GetReagentTypeForOrderableTest().ReagentTypeName;
					dr[TABLE.BloodUnitTest.ReactivityPhaseCode] = this.ReactivityPhase;
				}

				dt.Rows.Add(dr);
			}

			this.dgAntigenTyping.ToolTipColumn = dt.Columns.Count - 1;
			return dt;
		}
		
		/// <summary>
		/// Adds or removes two rows used to QC the reagent used for antigent typing
		/// </summary>
		/// <param name="addRows"></param>
		private void AddRemoveQCRowsToDataGrid(bool addRows)
		{
			if (addRows == true)
			{
				DataRow drNeg = this._dtAGT.NewRow();
				drNeg[TABLE.Patient.PatientGuid] = this._dtAGT.Rows[0][TABLE.Patient.PatientGuid];
				drNeg[TABLE.PatientSpecimen.PatientSpecimenGuid] = this._dtAGT.Rows[0][TABLE.PatientSpecimen.PatientSpecimenGuid];
				drNeg[TABLE.OrderedTest.OrderedTestGuid] = this._dtAGT.Rows[0][TABLE.OrderedTest.OrderedTestGuid];
				drNeg[TABLE.OrderableTest.OrderableTestId] = this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId];
				drNeg[ARTIFICIAL.Indicator] = string.Empty;
				drNeg[ARTIFICIAL.TestType] = "NEG";
				drNeg[TABLE.Reagent.LotNumber] = string.Empty;
				drNeg[ARTIFICIAL.VialId] = string.Empty;
				drNeg[ARTIFICIAL.IS] = string.Empty;
				drNeg[ARTIFICIAL.RT] = string.Empty;
				drNeg[ARTIFICIAL.C37] = string.Empty;
				drNeg[ARTIFICIAL.AHG] = string.Empty;
				drNeg[ARTIFICIAL.CC] = string.Empty;
				drNeg[ARTIFICIAL.Interp] = string.Empty;
				drNeg[ARTIFICIAL.Comment] = string.Empty;
				drNeg[ARTIFICIAL.LotNumberSave] = true;
				drNeg[ARTIFICIAL.VialIdSave] = true;
				drNeg[ARTIFICIAL.ISSave] = this._dtAGT.Rows[0][ARTIFICIAL.ISSave];
				drNeg[ARTIFICIAL.RTSave] = this._dtAGT.Rows[0][ARTIFICIAL.RTSave];
				drNeg[ARTIFICIAL.C37Save] = this._dtAGT.Rows[0][ARTIFICIAL.C37Save];
				drNeg[ARTIFICIAL.AHGSave] = this._dtAGT.Rows[0][ARTIFICIAL.AHGSave];
				drNeg[ARTIFICIAL.CCSave] = this._dtAGT.Rows[0][ARTIFICIAL.CCSave];
				drNeg[ARTIFICIAL.InterpSave] = true;
				drNeg[ARTIFICIAL.PartiallyCompleted] = false;
				drNeg[TABLE.BloodUnitTest.ReactivityPhaseCode] = this.ReactivityPhase;
				drNeg[ARTIFICIAL.OrderedTestRowVersion] = this._dtAGT.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
				drNeg[TABLE.Rack.RackGuid] = this._dtAGT.Rows[0][TABLE.Rack.RackGuid];
				drNeg[ARTIFICIAL.IndicatorMessage] = string.Empty;
				drNeg[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.PSDATNegControl;  //Screening Cell 1

				DataRow drPos = this._dtAGT.NewRow();
				drPos[TABLE.Patient.PatientGuid] = this._dtAGT.Rows[0][TABLE.Patient.PatientGuid];
				drPos[TABLE.PatientSpecimen.PatientSpecimenGuid] = this._dtAGT.Rows[0][TABLE.PatientSpecimen.PatientSpecimenGuid];
				drPos[TABLE.OrderedTest.OrderedTestGuid] = this._dtAGT.Rows[0][TABLE.OrderedTest.OrderedTestGuid];
				drPos[TABLE.OrderableTest.OrderableTestId] = this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId];
				drPos[ARTIFICIAL.Indicator] = string.Empty;
				drPos[ARTIFICIAL.TestType] = "POS";
				drPos[TABLE.Reagent.LotNumber] = string.Empty;
				drPos[ARTIFICIAL.VialId] = string.Empty;
				drPos[ARTIFICIAL.IS] = string.Empty;
				drPos[ARTIFICIAL.RT] = string.Empty;
				drPos[ARTIFICIAL.C37] = string.Empty;
				drPos[ARTIFICIAL.AHG] = string.Empty;
				drPos[ARTIFICIAL.CC] = string.Empty;
				drPos[ARTIFICIAL.Interp] = string.Empty;
				drPos[ARTIFICIAL.Comment] = string.Empty;
				drPos[ARTIFICIAL.LotNumberSave] = true;
				drPos[ARTIFICIAL.VialIdSave] = true;
				drPos[ARTIFICIAL.ISSave] = this._dtAGT.Rows[0][ARTIFICIAL.ISSave];
				drPos[ARTIFICIAL.RTSave] = this._dtAGT.Rows[0][ARTIFICIAL.RTSave];
				drPos[ARTIFICIAL.C37Save] = this._dtAGT.Rows[0][ARTIFICIAL.C37Save];
				drPos[ARTIFICIAL.AHGSave] = this._dtAGT.Rows[0][ARTIFICIAL.AHGSave];
				drPos[ARTIFICIAL.CCSave] = this._dtAGT.Rows[0][ARTIFICIAL.CCSave];
				drPos[ARTIFICIAL.InterpSave] = true;
				drPos[ARTIFICIAL.PartiallyCompleted] = false;
				drPos[TABLE.BloodUnitTest.ReactivityPhaseCode] = this.ReactivityPhase;
				drPos[ARTIFICIAL.OrderedTestRowVersion] = this._dtAGT.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
				drPos[TABLE.Rack.RackGuid] = this._dtAGT.Rows[0][TABLE.Rack.RackGuid];
				drPos[ARTIFICIAL.IndicatorMessage] = string.Empty;
				drPos[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.PSDATPosControl;  //Check Cells

				object[] objPatient = this._dtAGT.Rows[0].ItemArray;
				DataRow drPatient = this._dtAGT.NewRow();
				drPatient.ItemArray = objPatient;

				this._dtAGT.Rows.Add(drPos);
				this._dtAGT.Rows.Add(drNeg);
				this._dtAGT.Rows.Add(drPatient);
				this._dtAGT.Rows.RemoveAt(0);

				//this.dgAntigenTyping.CurrentCell = new DataGridCell(0,0);
			}
			else
			{
				if (this._dtAGT.Rows.Count > 1)
				{
					this._dtAGT.Rows.RemoveAt(0);
					this._dtAGT.Rows.RemoveAt(0);
				}
			}
		}

		/// <summary>
		/// Sets the DataTable containing the currently active antisera as the datasource
		/// for a grid
		/// </summary>
		public void ActivateAntisera()
		{
			if (this.DataSourceTables.Count > 0)
			{
				this.dgAntigenTyping.ColumnHeadersVisible = true;

				DataTable dt = (DataTable)this.DataSourceTables[this._activeAntisera];

				this.cmbBoxComment.SelectedIndex = -1;

				if (dt.Rows.Count == 0)
				{
					this.dgAntigenTyping.DataSource = dt.DefaultView;
					this.dgAntigenTyping.ColumnHeadersVisible = false;
				}
				else
				{
					this.dgAntigenTyping.ColumnHeadersVisible = true;
					this.dgAntigenTyping.DataSource = dt.DefaultView;
					((DataView)dgAntigenTyping.DataSource).AllowNew = false;
					((DataView)dgAntigenTyping.DataSource).AllowDelete = false;

					this._dtAGT = dt;
					for (int i=0 ; i<dt.Rows.Count ; i++)
					{
						UpdateIndicator(i);
					}
				}
				this._dgAntigenTypingTableStyle.MappingName = dt.TableName;

				if (dt.Rows.Count == 1)
				{
					if (dt.Rows[0].IsNull(TABLE.Reagent.ReagentGuid))
					{
						this.OnTabActivated((int)dt.Rows[0][TABLE.Reagent.ReagentTypeId], dt.Rows[0][TABLE.ReagentType.ReagentTypeName].ToString());
					}
				}

				if (dt.Rows.Count > 0)
				{
					if ((int)this._dtAGT.Rows[0][TABLE.ReactivityPhase.ReactivityPhaseCode]  == (int)Common.ReactivityPhase.ThreeSevenandAHG)
					{
					    var dataGridColumnStyle = this._dgAntigenTypingTableStyle.GridColumnStyles[ARTIFICIAL.VialId];
					   //CR 3554
                        if (dataGridColumnStyle != null)
					        dataGridColumnStyle.Width = 0;
					    var gridColumnStyle = this._dgAntigenTypingTableStyle.GridColumnStyles[ARTIFICIAL.TestType];
					    if (gridColumnStyle != null)
					        gridColumnStyle.Width = 95;
					}
					else
					{
					    var dataGridColumnStyle = this._dgAntigenTypingTableStyle.GridColumnStyles[ARTIFICIAL.VialId];
					    if (dataGridColumnStyle != null)
					        dataGridColumnStyle.Width = 50;
					    var gridColumnStyle = this._dgAntigenTypingTableStyle.GridColumnStyles[ARTIFICIAL.TestType];
					    if (gridColumnStyle != null)
					        gridColumnStyle.Width = 45;
					}
				}
			}
		}

		/// <summary>
		/// Adds the DataTable to the list of data source tables (one table for each antisera)
		/// </summary>
		/// <param name="dt"></param>
		/// <param name="test"></param>
		public void AddToDataSource(DataTable dt, BOL.OrderedTest test)
		{
			this.DataSourceTables.Add(dt);
			this.AddAntigenTab(dt.TableName, test);
			this.btnClear.Enabled = true;
			enableInvalidation = true;
		}

		/// <summary>
		/// Removes the currently selected tab
		/// </summary>
		/// <returns></returns>
		public string RemoveCurrentTab()
		{
			string tabName;

			if (this.tabControl1.TabPages.Count == 0)
				return string.Empty;

			tabName = ((DataTable)this.DataSourceTables[this._activeAntisera]).TableName;
			this.DataSourceTables.RemoveAt(this._activeAntisera);
			this.TabRemoved = true;
			this.tabControl1.TabPages.RemoveAt(this._activeAntisera);

			if (this.DataSourceTables.Count > 0)
			{
				this._activeAntisera = 0;
				this.tabControl1.SelectedIndex = 0;
				this.ActivateAntisera();
			}
			else
			{
				this.dgAntigenTyping.DataSource = new DataTable();
				this.dgAntigenTyping.ColumnHeadersVisible = false;
				this.tabControl1.SelectedIndex = -1;
			}

			return tabName;
		}

		/// <summary>
		/// Clears all tabs and datasources allowing setup for another patient
		/// </summary>
		public void ClearDataSourceAndTabs()
		{
			this.DataSourceTables.Clear();
			this._dgAntigenTypingTableStyle.MappingName = string.Empty;
			this.btnClear.Enabled = false;
			enableInvalidation = false;
			this.tabControl1.Controls.Clear();
		}

		/// <summary>
		/// Enables or disables the grid
		/// </summary>
		/// <param name="status"></param>
		public void SetGridStatus(bool status)
		{
			this.dgAntigenTyping.Enabled = status;
		}

		/// <summary>
		/// Check if data on the grid is ready to be saved
		/// </summary>
		/// <returns></returns>
		public bool IsReadyToSave()
		{
			if (this.DataSourceTables.Count == 0)
				return true;

			foreach (DataTable dt in this.DataSourceTables)
			{
				if (this._division.ServiceTypeIndicator == true ||
					this.ActiveOrder.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					for (int i=0 ; i<dt.Rows.Count ; i++)
					{
						if (dt.Rows[i].IsNull(TABLE.Reagent.ReagentGuid) == true ||
							dt.Rows[i][ARTIFICIAL.Indicator].ToString() == "E")
							return false;
					}
				}
				else
				{
					for (int i=0 ; i<dt.Rows.Count ; i++)
					{
						if (dt.Rows[i][ARTIFICIAL.Indicator].ToString() == string.Empty)
							return false;
					}
				}
			}

			return true;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// </summary>
		private void AddAGTCustomDataTableStyle()
		{
			_dgAntigenTypingTableStyle = new DataGridTableStyle();
			_dgAntigenTypingTableStyle.PreferredRowHeight = 22;
			dgAntigenTyping.TableStyles.Add(_dgAntigenTypingTableStyle);

			_dgAntigenTypingTableStyle.AllowSorting = false;
			_dgAntigenTypingTableStyle.DataGrid = this.dgAntigenTyping;

			_dgAntigenTypingTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgAntigenTypingTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgAntigenTypingTableStyle.MappingName = string.Empty;
			_dgAntigenTypingTableStyle.RowHeadersVisible = false;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// PatientControl
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = string.Empty;
			_dcTextBox.MappingName = ARTIFICIAL.TestType;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 45;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// Lot Number
			// 
			if (this._division != null)
			{
				if (this._division.ServiceTypeIndicator == true)
				{
					_dcTextBox = new DataGridTextBoxColumn();
					_dcTextBox.HeaderText = "Lot Number";
					_dcTextBox.MappingName = TABLE.Reagent.LotNumber;
					_dcTextBox.Width = 100;
					_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
					_dcTextBox.TextBox.Controls.Add(cmbBox);
					cmbBox.BringToFront();
					cmbBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
				}
				else
				{
					_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
					_dcTextKeyTrapCol.HeaderText = "Lot Number";
					_dcTextKeyTrapCol.MappingName = TABLE.Reagent.LotNumber;
					_dcTextKeyTrapCol.Width = 100;
					_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
				}
			}
			// 
			// VialID
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.HeaderText = "Vial ID";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.VialId;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// IS
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// RT
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.RT;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.RT;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// 37
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// AHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// CC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// Interp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Interp;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			//CR 2792
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// Comment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = ARTIFICIAL.Comment;
			_dcTextBox.MappingName = ARTIFICIAL.Comment;
			_dcTextBox.Width = 290;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			_dcTextBox.TextBox.Controls.Add(cmbBoxComment);
			cmbBoxComment.BringToFront();
			cmbBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			// 
			// dcPatientGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Patient.PatientGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPatientSpecimenGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.PatientSpecimen.PatientSpecimenGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedTestGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.OrderedTestGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Reagent.ReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentTypeID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReagentType.ReagentTypeId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentTypeName
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReagentType.ReagentTypeName;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcManufacturer
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.Manufacturer;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcExpirationDate
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ExceptionExpiredUnitReceived.ExpirationDate;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderableTestID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcSystemInterp
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ValidRhResult.SystemInterp;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPartiallyCompleted
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcLotNumberSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.LotNumberSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcVialIDSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.VialIdSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRTSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RTSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37Save
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Save;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcInterpSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRTGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RTGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37Guid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Guid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcInterpGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRTRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RTRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37RowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37RowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcInterpRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReactivityPhaseCode
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.BloodUnitTest.ReactivityPhaseCode;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCprsOrderNumber
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.CprsOrderNumber;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRowVersionOrderedTest
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OrderedTestRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentExpiredException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ReagentExpiredException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcDiscrepantTypingException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.DiscrepantTypingException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPhaseChangedException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PhaseChangedException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCorrectedResultIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.SpecimenTest.CorrectedResultIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRackGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Rack.RackGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcIndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgAntigenTypingTableStyle.GridColumnStyles.Add(_dcTextBox);

		}

		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// BR_2.28
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void _dcTextKeyTrapCol_TextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			int row = this.dgAntigenTyping.CurrentCell.RowNumber;
			int column = this.dgAntigenTyping.CurrentCell.ColumnNumber;
			string cellText = string.Empty;
			string cellTextFuture = string.Empty;
			string KeyChar = string.Empty;
			string regPattern = string.Empty;
			bool findNextCell = true;
			
			TextBox c = (TextBox) sender;

			cellText = c.Text;
			
			// Let backspace and enter keys bypass
			if (!char.IsLetterOrDigit(e.KeyChar))
			{
				if ((column == 9 || column == 3) && e.KeyChar == System.Convert.ToChar(Keys.Enter))
				{
					SetNextCell();
				}

				e.Handled = !char.IsControl(e.KeyChar);
				return;
			}

			if (column == 10)
				return;
			
			// Turn single character to upper
			KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

			// Obtain what the string will look like after key is pressed
			if (cellText.Length > 0)
			{
				cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
			}
			else
			{
				cellTextFuture = KeyChar;
			}

			// Test what type of column it is and then apply the regular expression

			if (column == 9)  // interp
			{
				//CR 2653 removed I from the list of possible interpretations for antigen typing
				if (System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.AGwD &&
					System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.RepeatAGwD)
				{
					regPattern = @"(\A[PN]\z)";
					findNextCell = true;
				}
				else
				{
					regPattern = @"(\A[PNI]\z)";
					findNextCell = true;
				}
			}
			else if (column == 4 || column == 5 ||
				column == 6 || column == 7)	// IS RT 37 AHG
			{
				regPattern = @"(\A[HWFM01234RX]\z)";
				findNextCell = true;
			}
			else if (column == 8)	// CC
			{
				if (this._dtAGT.Rows[row][ARTIFICIAL.AHG].ToString() == "0")
				{
					regPattern = @"(\A[HWFM1234R]\z)";
				}
				else
				{
					regPattern = @"(\A[HWFM1234RX]\z)";
				}
				findNextCell = true;
			}
			else if (column == 3)
			{
				regPattern = @"(\A[0-9]{1,2}\Z)";
				findNextCell = false;
			}

			if (Regex.IsMatch(cellTextFuture, regPattern))
			{
				//changing values in the datable causes TextChanged event to be fired
				//setting a flag to prevent it from happening CR 2792
				this._keyPressEventHandled = true;
				c.Text = cellTextFuture;
				c.SelectionStart = c.SelectionLength + 1;
				DataTable dt = ((DataView)this.dgAntigenTyping.DataSource).Table;
				dt.Rows[row][column] = c.Text;
				if (findNextCell == true)
				{
					SetNextCell();
					UpdateIndicator(row);
				}
				this._keyPressEventHandled = false;
			}
			else
			{
				//BR_2.28
				GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
			}
			
			e.Handled = true;
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void _dcTextKeyTrapCol_TextChanged(object sender, EventArgs e)
		{
			//if the grid just received focus do not continue executing this event
			if (this.dgAntigenTyping.GridEntered == true)
			{
				this.dgAntigenTyping.GridEntered = false;
				return;
			}

			if (this._keyPressEventHandled || this.dgAntigenTyping.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgAntigenTyping.CurrentCell.RowNumber;
				int column = this.dgAntigenTyping.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgAntigenTyping.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 9)  // interp
						{
							if (System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.AGwD &&
								System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.RepeatAGwD)
							{
								regPattern = @"(\A[PN]\z)";
							}
							else
							{
								regPattern = @"(\A[PNI]\z)";
							}
						}
						else if (column == 4 || column == 5 ||
							column == 6 || column == 7)	// IS RT 37 AHG
						{
							regPattern = @"(\A[HWFM01234RX]\z)";
						}
						else if (column == 8)	// CC
						{
							if (this._dtAGT.Rows[row][ARTIFICIAL.AHG].ToString() == "0")
							{
								regPattern = @"(\A[HWFM1234R]\z)";
							}
							else
							{
								regPattern = @"(\A[HWFM1234RX]\z)";
							}
						}
						else if (column == 3)
						{
							regPattern = @"(\A[0-9]{1,2}\Z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							for (int i=0 ; i<this._dtAGT.Rows.Count ; i++)
							{
								UpdateIndicator(i);
							}
							this.dgAntigenTyping.Refresh();
							OnCellChanged(EventArgs.Empty);
							this._keyPressEventHandled = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandled = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
						//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandled = true;
						dt.Rows[row][column] = "";
						for (int i=0 ; i<this._dtAGT.Rows.Count ; i++)
						{
							UpdateIndicator(i);
						}
						this.dgAntigenTyping.Refresh();
						OnCellChanged(EventArgs.Empty);
						this._keyPressEventHandled = false;
					}
				}
			}
		}

		/// <summary>
		/// Controls the movement of the cursor on the datagrid.
		/// </summary>
		private void SetNextCell()
		{
			int row = this.dgAntigenTyping.CurrentCell.RowNumber;
			int col = this.dgAntigenTyping.CurrentCell.ColumnNumber;

			if (row == this._dtAGT.Rows.Count - 1)
			{
				if (col < 10 && col > 1)
				{
					this.dgAntigenTyping.SetCurrentCell(0, col+1);
				}
				else if (col == 10)
				{
					this.dgAntigenTyping.SetCurrentCell(0, 0);
				}
			}
			else
			{
				this.dgAntigenTyping.SetCurrentCell(row + 1, col);
			}
		}

		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// </summary>
		private void UpdateIndicator(int row)
		{
			if (this.tabControl1.TabPages.Count == 0)
				return;

			if (this._division.ServiceTypeIndicator == true ||
				this.ActiveOrder.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				string SystemInterp = string.Empty;
				DataRow drUpdate = this._dtAGT.Rows[row];
				string Interp = drUpdate[ARTIFICIAL.Interp].ToString();
				string Comment = drUpdate[ARTIFICIAL.Comment].ToString();
				Common.ReactivityPhase phase;
			
				if (this._dtAGT.Rows[0].IsNull(TABLE.BloodUnitTest.ReactivityPhaseCode))
				{
					phase = Common.ReactivityPhase.Unknown;
				}
				else
				{
					phase = (Common.ReactivityPhase)Convert.ToInt32(this._dtAGT.Rows[0][TABLE.BloodUnitTest.ReactivityPhaseCode]);
				}

				//			DialogResult result;

				if (System.Convert.ToInt32(this._dtAGT.Rows[row][TABLE.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD ||
					System.Convert.ToInt32(this._dtAGT.Rows[row][TABLE.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.RepeatAGwD)
				{
					if (row == 0)
					{
						string ErrorMessage = BOL.AntigenTyping.InterpretWeakDResults(this._dtAGT);

						if (drUpdate[ARTIFICIAL.Indicator].ToString() == string.Empty)
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
						else
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
						}

						if ((ErrorMessage != string.Empty && _lastErrorMessage != ErrorMessage) ||
							ErrorMessage == string.Empty)
						{
							drUpdate[ARTIFICIAL.IndicatorMessage] = ErrorMessage;
							_lastErrorMessage = ErrorMessage;
						}
					}
				}
				else
				{
					SystemInterp = BOL.AntigenTyping.InterpretPhenotypeResults(drUpdate);

					if (SystemInterp == String.Empty)
					{
						drUpdate[ARTIFICIAL.Interp] = string.Empty;
					}

					if (Interp == string.Empty)
					{
						drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
					}
					else if (SystemInterp == Interp)
					{
						if ((drUpdate[ARTIFICIAL.TestType].ToString() == "POS" && Interp == "N") ||
							(drUpdate[ARTIFICIAL.TestType].ToString() == "NEG" && Interp == "P"))
						{
							drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.Common.InterpretationNotMatch().ResString;
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
							drUpdate[ARTIFICIAL.Indicator] = "E";
						}
						else
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
							drUpdate[ARTIFICIAL.Indicator] = "V";
							drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						}
					}
					else if ((SystemInterp == "P" ||
						SystemInterp == "N" ||
						SystemInterp == "I") &&
						SystemInterp != Interp)
					{
						if (Comment == string.Empty)
						{
							drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.Common.InterpretationNotMatch().ResString;
							drUpdate[ARTIFICIAL.Indicator] = "E";
						}
						else
						{
							drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
							drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.Common.InterpretationNotMatch().ResString;
							drUpdate[ARTIFICIAL.Indicator] = "W";
						}
					}
					else if (SystemInterp == "X")
					{
						if ((phase == Common.ReactivityPhase.ISandRT && (drUpdate[ARTIFICIAL.RT].ToString() == string.Empty || drUpdate[ARTIFICIAL.RT].ToString() == "X")) ||
							(phase == Common.ReactivityPhase.ISand37 && (drUpdate[ARTIFICIAL.C37].ToString() == string.Empty || drUpdate[ARTIFICIAL.C37].ToString() == "X")))
						{
							if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E" &&
								drUpdate[ARTIFICIAL.IS].ToString().Trim() != string.Empty)
							{
								drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.UC098.ISOnlyResults().ResString;
								drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								drUpdate[ARTIFICIAL.Indicator] = "E";
							}
						}
						else
						{
							if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
							{
								drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.Common.InterpretationNotMatch().ResString;
								drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								drUpdate[ARTIFICIAL.Indicator] = "E";
							}
						}
					}
					else
					{
						drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
					}
				}

				if (Interp != string.Empty && drUpdate[ARTIFICIAL.TestType].ToString() == "Patient" && drUpdate[ARTIFICIAL.Indicator].ToString() == "V")
				{
					if (drUpdate.IsNull(ARTIFICIAL.DiscrepantTypingException))
					{
						BOL.OrderedTest ActiveOrder = (BOL.OrderedTest)this.tabControl1.TabPages[this._activeAntisera].Tag;
						DataTable dtHistoricalResults = ActiveOrder.GetHistoricalTestResultsForOrderedTest();
						if (dtHistoricalResults.Rows.Count > 0)
						{
							DataRow[] dtHistoricalInterps = dtHistoricalResults.Select("BloodTestName LIKE '*Interp*'");
							if (dtHistoricalInterps.Length > 0)
							{
								foreach(DataRow drHistoricalInterp in dtHistoricalInterps)
								{
									if (Interp != drHistoricalInterp[TABLE.TestResult.TestResultId].ToString().Trim() &&
										drHistoricalInterp[TABLE.TestResult.TestResultId].ToString().Trim() != string.Empty)
									{
										drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.UC098.HistoricalMismatch().ResString;
										DlgOverrideComment dlg = new DlgOverrideComment("Discrepant Antigen Typing", Common.StrRes.ConfMsg.UC098.HistoricalMismatch().ResString, "PT");
										if (dlg.ShowDialog(this.FindForm()) == DialogResult.Cancel)
										{
											drUpdate[ARTIFICIAL.Interp] = string.Empty;
										}
										else
										{
											drUpdate[ARTIFICIAL.Indicator] = "W";
											BOL.Reagent reagent = new BOL.Reagent((Guid)drUpdate[TABLE.Reagent.ReagentGuid]);
											BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Discrepant_patient_antigen_typing, dlg.Comment, Common.LogonUser.LogonUserName);
											exRep.GenerateExceptionPatientAntigenDiscrepancy(ActiveOrder, drUpdate[TABLE.ReagentType.ReagentTypeName].ToString(), reagent.ReagentName, drUpdate[TABLE.Reagent.LotNumber].ToString(), drUpdate[ARTIFICIAL.Manufacturer].ToString(),
												(DateTime)drUpdate[TABLE.ExceptionExpiredUnitReceived.ExpirationDate], drHistoricalInterp[TABLE.TestResult.TestResultId].ToString().Trim(), Interp, this._testingTech);
											drUpdate[ARTIFICIAL.DiscrepantTypingException] = exRep;
										}
										break;
									}
								}
							}
						}
					}
					else
					{
						drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.Tooltips.UC098.HistoricalMismatch().ResString;
						drUpdate[ARTIFICIAL.Indicator] = "W";
					}
				}
				else
				{
					drUpdate[ARTIFICIAL.DiscrepantTypingException] = DBNull.Value;
				}
			}
			else //Transfusion-Only
			{
				if (this._dtAGT.Rows[0][ARTIFICIAL.Interp].ToString().Trim() == string.Empty)
				{
					foreach (DataRow dr in this._dtAGT.Rows)
					{
						dr[ARTIFICIAL.Indicator] = string.Empty;
						dr[ARTIFICIAL.IndicatorMessage] = string.Empty;
						dr[ARTIFICIAL.PartiallyCompleted] = true;
					}
				}
				else
				{
					foreach (DataRow dr in this._dtAGT.Rows)
					{
						dr[ARTIFICIAL.Indicator] = "V";
						dr[ARTIFICIAL.IndicatorMessage] = string.Empty;
						dr[ARTIFICIAL.PartiallyCompleted] = false;
					}
				}
			}
		}

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// </summary>
		/// <param name="column"></param>
		public void SetValidEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression

			int row = this.dgAntigenTyping.CurrentCell.RowNumber;
			
			if (column == 2)	//Lot Number
			{
				_validEntries = "Lot Number";
			}
			else if (column == 3)	//Vial ID
			{
				_validEntries = "1 - 99";
			}
			else if (column == 4 || column == 5 ||
					 column == 6 || column == 7)		//IS RT 37 AHG
			{
				_validEntries = "0 = No Agglutination   1 = 1+   2 = 2+   3 = 3+   4 = 4+   W = Weak\nF = Mixed Field   R = Rouleaux   M = Microscopic   X = Not Tested";
			}
			else if (column == 8)		//CC
			{
				if (this._dtAGT.Rows[row][ARTIFICIAL.AHG].ToString() == "0")
				{
					_validEntries = "1 = 1+   2 = 2+   3 = 3+   4 = 4+   W = Weak\nF = Mixed Field   R = Rouleaux   M = Microscopic";
				}
				else
				{
					_validEntries = "1 = 1+   2 = 2+   3 = 3+   4 = 4+   W = Weak\nF = Mixed Field   R = Rouleaux   M = Microscopic   X = Not Tested";
				}
			}
			else if (column == 9)  // interp
			{
				//CR 2653 removed I from the list of possible interpretations for antigen typing

				if (System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.AGwD &&
					System.Convert.ToInt32(this._dtAGT.Rows[0][TABLE.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.RepeatAGwD)
				{
					_validEntries = "P = Positive   N = Negative";
				}
				else
				{
					_validEntries = "P = Positive   N = Negative   I = Inconclusive";
				}
			}
			else if (column == 10)		// Comment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = "Read-Only";
			}
		}

		/// <summary>
		/// Clears the test results from the grid. Restores datagrid to the initial status.
		/// </summary>
		private void ClearTestResults(bool clearAll)
		{
			if (this._dtAGT.Rows.Count > 0)
			{
				if (this._division.ServiceTypeIndicator == true ||
					this.ActiveOrder.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					foreach(DataRow drAGT in this._dtAGT.Rows)
					{
						if ((bool)drAGT[ARTIFICIAL.LotNumberSave] == true ||
							clearAll == true)
						{
							drAGT[TABLE.Reagent.LotNumber] = string.Empty;
							drAGT[TABLE.ExceptionExpiredUnitReceived.ExpirationDate] = DBNull.Value;
							drAGT[ARTIFICIAL.Manufacturer] = string.Empty;
							drAGT[TABLE.Reagent.ReagentGuid] = DBNull.Value;
							if (clearAll == true)
								drAGT[ARTIFICIAL.LotNumberSave] = true;
						}

						if ((bool)drAGT[ARTIFICIAL.VialIdSave] == true ||
							clearAll == true)
						{
							if (drAGT[ARTIFICIAL.VialId] != DBNull.Value)
							{
								drAGT[ARTIFICIAL.VialId] = string.Empty;
								if (clearAll == true)
									drAGT[ARTIFICIAL.VialIdSave] = true;
							}
						}

						if ((bool)drAGT[ARTIFICIAL.ISSave] == true ||
							clearAll == true)
						{
							drAGT[ARTIFICIAL.IS] = string.Empty;
							if (clearAll == true)
							{
								drAGT[ARTIFICIAL.ISGuid] = DBNull.Value;
								drAGT[ARTIFICIAL.ISRowVersion] = DBNull.Value;
								drAGT[ARTIFICIAL.ISSave] = true;
							}
						}

						if ((bool)drAGT[ARTIFICIAL.RTSave] == true ||
							clearAll == true)
						{
							drAGT[ARTIFICIAL.RT] = string.Empty;
							if (clearAll == true)
							{
								drAGT[ARTIFICIAL.RTGuid] = DBNull.Value;
								drAGT[ARTIFICIAL.RTRowVersion] = DBNull.Value;
								drAGT[ARTIFICIAL.RTSave] = true;
							}
						}

						if ((bool)drAGT[ARTIFICIAL.C37Save] == true ||
							clearAll == true)
						{
							drAGT[ARTIFICIAL.C37] = string.Empty;
							if (clearAll == true)
							{
								drAGT[ARTIFICIAL.C37Guid] = DBNull.Value;
								drAGT[ARTIFICIAL.C37RowVersion] = DBNull.Value;
								drAGT[ARTIFICIAL.C37Save] = true;
							}
						}

						if ((bool)drAGT[ARTIFICIAL.AHGSave] == true ||
							clearAll == true)
						{
							drAGT[ARTIFICIAL.AHG] = string.Empty;
							if (clearAll == true)
							{
								drAGT[ARTIFICIAL.AHGGuid] = DBNull.Value;
								drAGT[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
								drAGT[ARTIFICIAL.AHGSave] = true;
							}
						}

						if ((bool)drAGT[ARTIFICIAL.CCSave] == true ||
							clearAll == true)
						{
							drAGT[ARTIFICIAL.CC] = string.Empty;
							if (clearAll == true)
							{
								drAGT[ARTIFICIAL.CCGuid] = DBNull.Value;
								drAGT[ARTIFICIAL.CCRowVersion] = DBNull.Value;
								drAGT[ARTIFICIAL.CCSave] = true;
							}
						}

						if ((bool)drAGT[ARTIFICIAL.InterpSave] == true ||
							clearAll == true)
						{
							drAGT[ARTIFICIAL.Interp] = string.Empty;
							if (clearAll == true)
							{
								drAGT[ARTIFICIAL.InterpGuid] = DBNull.Value;
								drAGT[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
								drAGT[ARTIFICIAL.InterpSave] = true;
							}
						}

						drAGT[ARTIFICIAL.Comment] = string.Empty;
						drAGT[ARTIFICIAL.ReagentExpiredException] = DBNull.Value;
						drAGT[ARTIFICIAL.DiscrepantTypingException] = DBNull.Value;
					}
				}
				else
				{
					foreach(DataRow drAGT in this._dtAGT.Rows)
					{
						if ((bool)drAGT[ARTIFICIAL.InterpSave] == true ||
							clearAll == true)
						{
							drAGT[ARTIFICIAL.Interp] = string.Empty;
							if (clearAll == true)
							{
								drAGT[ARTIFICIAL.InterpGuid] = DBNull.Value;
								drAGT[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
								drAGT[ARTIFICIAL.InterpSave] = true;
							}
						}

						drAGT[ARTIFICIAL.Comment] = string.Empty;
					}
				}

				for (int i=0; i<this._dtAGT.Rows.Count; i++)
				{
					UpdateIndicator(i);
				}
			}
		}

		/// <summary>
		/// Handles the CellChanged event for datagrid. Controls the movement of the cursor
		/// on the gird and updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgAntigenTyping_CurrentCellChanged(object sender, System.EventArgs e)
		{
			if (this.tabControl1.TabPages.Count == 0)
				return;

			int col = this.dgAntigenTyping.CurrentCell.ColumnNumber;
			int row = this.dgAntigenTyping.CurrentCell.RowNumber;
			bool WeakDTyping = false;

			if (System.Convert.ToInt32(this._dtAGT.Rows[row][TABLE.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD ||
				System.Convert.ToInt32(this._dtAGT.Rows[row][TABLE.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.RepeatAGwD)
			{
				WeakDTyping = true;
			}

			if (this._division.ServiceTypeIndicator == true ||
				this.ActiveOrder.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				Common.ReactivityPhase phase = (Common.ReactivityPhase)Convert.ToInt32(this._dtAGT.Rows[0][TABLE.BloodUnitTest.ReactivityPhaseCode]);

				if (this._dtAGT.Rows[row].IsNull(TABLE.Reagent.ReagentGuid) && col != 2)
				{
					this.dgAntigenTyping.SetCurrentCell(row, 2);
					return;
				}
				else if (this._dtAGT.Rows[row][ARTIFICIAL.TestType].ToString().Trim() != "Patient" && 
						this._dtAGT.Rows[row][ARTIFICIAL.VialId].ToString().Trim() == string.Empty && 
						col > 3 && 
						WeakDTyping == false)
				{
					this.dgAntigenTyping.SetCurrentCell(row, 3);
					return;
				}

				if (col == 0 || col == 1)
				{
					this.dgAntigenTyping.SetCurrentCell(row, 2);
					return;
				}

				switch(this.dgAntigenTyping.CurrentCell.ColumnNumber)
				{
					case 2:
						if (this._dtAGT.Rows[row][ARTIFICIAL.TestType].ToString() == "Patient")
						{
							SetNextCell();
							return;
						}
						else if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.LotNumberSave] == false)
						{
							SetNextCell();
							return;
						}
						break;
					case 3:
						if (WeakDTyping == false)
						{
							if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.VialIdSave] == false)
							{
								SetNextCell();
								return;
							}
							else if (this._dtAGT.Rows[row][ARTIFICIAL.TestType].ToString() == "Patient")
							{
								SetNextCell();
								return;
							}
						}
						else
						{
							this.dgAntigenTyping.SetCurrentCell(row, col+1);
						}
						break;
					case 4:
						if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.ISSave] == false ||
							phase == Common.ReactivityPhase.AHGandCC ||
							phase == Common.ReactivityPhase.ThreeSevenandAHG)
						{
							SetNextCell();
							return;
						}
						break;
					case 5:
						if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.RTSave] == false ||
							phase == Common.ReactivityPhase.AHGandCC ||
							phase == Common.ReactivityPhase.IS ||
							phase == Common.ReactivityPhase.ISand37 ||
							phase == Common.ReactivityPhase.ThreeSevenandAHG)
						{
							SetNextCell();
							return;
						}
						break;
					case 6:
						if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.C37Save] == false ||
							phase == Common.ReactivityPhase.AHGandCC ||
							phase == Common.ReactivityPhase.IS ||
							phase == Common.ReactivityPhase.ISandRT)
						{
							SetNextCell();
							return;
						}
						break;
					case 7:
						if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.AHGSave] == false ||
							phase == Common.ReactivityPhase.IS ||
							phase == Common.ReactivityPhase.ISand37 ||
							phase == Common.ReactivityPhase.ISandRT)
						{
							SetNextCell();
							return;
						}
						break;
					case 8:
						if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.CCSave] == false ||
							phase == Common.ReactivityPhase.IS ||
							phase == Common.ReactivityPhase.ISand37 ||
							phase == Common.ReactivityPhase.ISandRT)
						{
							SetNextCell();
							return;
						}
						break;
					case 9:
						if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.InterpSave] == false)
						{
							SetNextCell();
							return;
						}
						if (((Common.Utility.GetReactivityPhaseTextFromCode(this._dtAGT.Rows[row][TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.IS)>-1) && (this._dtAGT.Rows[row][ARTIFICIAL.IS].ToString().Length==0))||
							((Common.Utility.GetReactivityPhaseTextFromCode(this._dtAGT.Rows[row][TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.RT)>-1) && (this._dtAGT.Rows[row][ARTIFICIAL.RT].ToString().Length==0))||
							((Common.Utility.GetReactivityPhaseTextFromCode(this._dtAGT.Rows[row][TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.C37)>-1) && (this._dtAGT.Rows[row][ARTIFICIAL.C37].ToString().Length==0))||
							((Common.Utility.GetReactivityPhaseTextFromCode(this._dtAGT.Rows[row][TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._dtAGT.Rows[row][ARTIFICIAL.AHG].ToString().Length==0))||
							((Common.Utility.GetReactivityPhaseTextFromCode(this._dtAGT.Rows[row][TABLE.RackLot.ReactivityPhaseCode].ToString()).IndexOf(ARTIFICIAL.AHG)>-1) && (this._dtAGT.Rows[row][ARTIFICIAL.CC].ToString().Length==0)))
						{
							//Can't enter an interp, if the phases aren't complete
							this.dgAntigenTyping.SetCurrentCell(row, 0);
							return;
						}
						break;
				}
			}
			else //Transfusion-Only
			{
				if (col < 9 || row > 0)
				{
					this.dgAntigenTyping.SetCurrentCell(0, 9);
				}
			}

			if (col > 10)
				this.dgAntigenTyping.SetCurrentCell(row, 10);
			else if (col == 2)
			{
				if (this._dtAGT.Rows[row][ARTIFICIAL.TestType].ToString() == "POS" ||
					this._dtAGT.Rows[row][ARTIFICIAL.TestType].ToString() == "NEG")
				{
					DataTable dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.ReverseABO);
					this._dtReagents = dtTmpReagents.Copy();
					this._dtReagents.CaseSensitive = true;

					dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.A2Cell);
					foreach(DataRow dr in dtTmpReagents.Rows)
					{
						this._dtReagents.Rows.Add(dr.ItemArray);
					}

					dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.ScreeningCells);
					foreach(DataRow dr in dtTmpReagents.Rows)
					{
						this._dtReagents.Rows.Add(dr.ItemArray);
					}

					dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.CC);
					foreach(DataRow dr in dtTmpReagents.Rows)
					{
						this._dtReagents.Rows.Add(dr.ItemArray);
					}

					dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.CellPanel);
					foreach(DataRow dr in dtTmpReagents.Rows)
					{
						this._dtReagents.Rows.Add(dr.ItemArray);
					}
				
					dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.OtherSet);
					foreach(DataRow dr in dtTmpReagents.Rows)
					{
						this._dtReagents.Rows.Add(dr.ItemArray);
					}
				}
				else
				{
					_dtReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)this._dtAGT.Rows[row][TABLE.ReagentType.ReagentTypeId]);
					this._dtReagents.CaseSensitive = true;
				}

				DataView dv = new DataView(_dtReagents);
				dv.Sort = TABLE.Reagent.LotExpirationDate + " DESC";
				cmbBox.Items.Clear();
				foreach(DataRowView drReagent in dv)
				{
					cmbBox.Items.Add(drReagent.Row[TABLE.Reagent.LotNumber].ToString());
				}

				cmbBox.Text = this._dtAGT.Rows[row][TABLE.Reagent.LotNumber].ToString();

				cmbBox.Show();
				cmbBox.Focus();
			}
			else if (col == 10)
			{
				if ((bool)this._dtAGT.Rows[row][ARTIFICIAL.InterpSave] == false ||
					this._dtAGT.Rows[row][ARTIFICIAL.Interp].ToString() == string.Empty)
				{
					this.dgAntigenTyping.SetCurrentCell(row, col-1);
				}
				else
				{
					if (this.cmbBoxComment.Items.Count == 0)
					{
						DataTable dtCannedComments = BOL.CannedComment.GetCannedComments(this.DivisionCode, "PT");
						foreach (DataRow drComment in dtCannedComments.Rows)
						{
							this.cmbBoxComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
						}
					}
					this.cmbBoxComment.LookupEnabled = false;
					this.cmbBoxComment.Text = this._dtAGT.Rows[row][ARTIFICIAL.Comment].ToString();
					this.cmbBoxComment.Show();
					this.cmbBoxComment.Focus();
				}
			}

			for (int i=0 ; i<this._dtAGT.Rows.Count ; i++)
			{
				UpdateIndicator(i);
			}

			SetValidEntries(this.dgAntigenTyping.CurrentCell.ColumnNumber);
			OnCellChanged(EventArgs.Empty);
		}

		/// <summary>
		/// Handles the KeyDown event for combobox.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_KeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter)
			{
				if(this.dgAntigenTyping.CurrentCell.RowNumber < ((DataTable)this.dgAntigenTyping.DataSource).Rows.Count - 1)
				{
					this.dgAntigenTyping.SetCurrentCell(this.dgAntigenTyping.CurrentCell.RowNumber + 1, this.dgAntigenTyping.CurrentCell.ColumnNumber);
					cmbBox.Show();
					cmbBox.Focus();
				}
				else
				{
					this.dgAntigenTyping.SetCurrentCell(0, this.dgAntigenTyping.CurrentCell.ColumnNumber+1);
					cmbBox.Hide();
				}
			}
		}

		/// <summary>
		/// Handles the IndexChanged event for combobox. Finds the reagent based on the lot number
		/// chosen and populates grid with the appropriate data.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbBox.SelectedIndex != -1)
			{
				int row = this.dgAntigenTyping.CurrentCell.RowNumber;
				int column = this.dgAntigenTyping.CurrentCell.ColumnNumber;

                // CR2814: Add an escape character so queries with single quotes don't crash.
                DataRow drReagent = this._dtReagents.Select("LotNumber='" + cmbBox.SelectedItem.ToString().Replace("'", "''") + "'")[0];

				if (this._dtAGT.Rows[row][TABLE.Reagent.LotNumber].ToString().Trim() != drReagent[TABLE.Reagent.LotNumber].ToString().Trim())
				{
					if (this.CheckForExpiredAntisera(drReagent) == true &&
						this.CheckForSatisfactoryReagent(drReagent) == true)
					{
						this._dtAGT.Rows[row][TABLE.Reagent.LotNumber] = drReagent[TABLE.Reagent.LotNumber];
						this._dtAGT.Rows[row][TABLE.ExceptionExpiredUnitReceived.ExpirationDate] = drReagent[TABLE.Reagent.LotExpirationDate];
						this._dtAGT.Rows[row][ARTIFICIAL.Manufacturer] = drReagent[TABLE.Reagent.ReagentManufacturerName];
						this._dtAGT.Rows[row][TABLE.Reagent.ReagentGuid] = drReagent[TABLE.Reagent.ReagentGuid];

						if (this._dtAGT.Rows[row][ARTIFICIAL.TestType].ToString() == "Patient")
						{
							DataTable dtReagentTestResults = BOL.RackTest.GetReagentTestResult(this.DivisionCode, (Guid)this._dtAGT.Rows[row][TABLE.Reagent.ReagentGuid], this.TestingDateTime, Convert.ToChar(this.ReactivityPhase.ToString()));
							if (dtReagentTestResults.Rows.Count == 0 && this._dtAGT.Rows.Count == 1)
							{
								this.AddRemoveQCRowsToDataGrid(true);
							}
							else if (dtReagentTestResults.Rows.Count > 0 && this._dtAGT.Rows.Count == 3)
							{
								this.AddRemoveQCRowsToDataGrid(false);
							}
						}

						this.dgAntigenTyping.SetCurrentCell(row, 1);
					}
					else
					{
						cmbBox.Text = string.Empty;
						this.dgAntigenTyping.SetCurrentCell(row, 1);
					}
				}
			}
		}

		/// <summary>
		/// Checks if the user entered the valid lot number.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (this.cmbBox.SelectedIndex == -1 &&
				this.cmbBox.Text.Trim() != string.Empty)
				e.Cancel = true;
		}

		/// <summary>
		/// Copy the value entered in the comment combo box into the cell
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBoxComment_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			int row = this.dgAntigenTyping.CurrentCell.RowNumber;
			int col = this.dgAntigenTyping.CurrentCell.ColumnNumber;

			if (col == 10)
			{
				this._dtAGT.Rows[row][ARTIFICIAL.Comment] = this.cmbBoxComment.Text;
			}
		}

		/// <summary>
		/// Clears the datagrid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			ClearGrid();
		}

		/// <summary>
		/// Clears the grid. This method is public because it is being invoked by context menu from main form of the UC_56
		/// </summary>
		public void ClearGrid()
		{
			if (this.IsGridEmpty() == true)
				return;

			BOL.OrderedTest ActiveOrder = (BOL.OrderedTest)this.tabControl1.TabPages[this._activeAntisera].Tag;
			if (ActiveOrder.OrderableTestId != (int)Common.OrderableTest.AGwD &&
				ActiveOrder.OrderableTestId != (int)Common.OrderableTest.RepeatAGwD)
			{
				if (ActiveOrder.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					DlgOverrideComment dlg = new DlgOverrideComment("Inactivate test results", "Do you want to inactivate test results for this task?", "PT");
					if (dlg.ShowDialog(this.FindForm()) == DialogResult.OK)
					{
						BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Previously_recorded_results_inactivated, dlg.Comment, Common.LogonUser.LogonUserName);
						exRep.GenerateExceptionPatientTestInactivated(ActiveOrder, this._testingTech);
					
						ActiveOrder.InactivateTestResults(exRep, Common.UpdateFunction.AntigenTypingWeakDClearGrid);
						this.ClearTestResults(true);
						this.AddRemoveQCRowsToDataGrid(false);
					}
					else
						return;
				}
				else
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.ClearTestResults()) == DialogResult.Yes)
					{
						this.ClearTestResults(false);
						this.AddRemoveQCRowsToDataGrid(false);
					}
					else
						return;
				}
			}
			else
			{
				if (ActiveOrder.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					DlgOverrideComment dlg = new DlgOverrideComment("Inactivate test results", "Do you want to inactivate test results for this task?", "PT");
					if (dlg.ShowDialog(this.FindForm()) == DialogResult.OK)
					{
						BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Previously_recorded_results_inactivated, dlg.Comment, Common.LogonUser.LogonUserName);
						exRep.GenerateExceptionPatientTestInactivated(ActiveOrder, this._testingTech);
					
						ActiveOrder.InactivateTestResults(exRep, Common.UpdateFunction.AntigenTypingWeakDClearGrid);
						this.ClearTestResults(true);
					}
					else
						return;
				}
				else
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.ClearTestResults()) == DialogResult.Yes)
					{
						this.ClearTestResults(false);
					}
					else
						return;
				}
			}

			this._dtAGT.Rows[0][ARTIFICIAL.OrderedTestRowVersion] = this.ActiveOrder.RowVersion;
			this.OnTabActivated((int)this._dtAGT.Rows[0][TABLE.ReagentType.ReagentTypeId], this._dtAGT.Rows[0][TABLE.ReagentType.ReagentTypeName].ToString());
		}

		/// <summary>
		/// Check if grid is empty (contains no test results)
		/// </summary>
		/// <returns></returns>
		public bool IsGridEmpty()
		{
			if (this.dgAntigenTyping.DataSource == null)
			{
				return true;
			}

			foreach(DataRow dr in this._dtAGT.Rows)
			{
				if (dr[TABLE.Reagent.LotNumber].ToString().Trim() != string.Empty)
					return false;

				if (dr.IsNull(ARTIFICIAL.VialId) == false)
					if (dr[ARTIFICIAL.VialId].ToString().Trim() != string.Empty)
						return false;

				if (dr.IsNull(ARTIFICIAL.IS) == false)
					if (dr[ARTIFICIAL.IS].ToString().Trim() != string.Empty)
						return false;

				if (dr.IsNull(ARTIFICIAL.RT) == false)
					if (dr[ARTIFICIAL.RT].ToString().Trim() != string.Empty)
						return false;

				if (dr.IsNull(ARTIFICIAL.C37) == false)
					if (dr[ARTIFICIAL.C37].ToString().Trim() != string.Empty)
						return false;

				if (dr.IsNull(ARTIFICIAL.AHG) == false)
					if (dr[ARTIFICIAL.AHG].ToString().Trim() != string.Empty)
						return false;

				if (dr.IsNull(ARTIFICIAL.CC) == false)
					if (dr[ARTIFICIAL.CC].ToString().Trim() != string.Empty)
						return false;

				if (dr.IsNull(ARTIFICIAL.Interp) == false)
					if (dr[ARTIFICIAL.Interp].ToString().Trim() != string.Empty)
						return false;

				if (dr.IsNull(ARTIFICIAL.Comment) == false)
					if (dr[ARTIFICIAL.Comment].ToString().Trim() != string.Empty)
						return false;

			}

			return true;
		}

		/// <summary>
		/// Called when user clicks on the tab
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void pageAntisera_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.DataSourceTables.Count == 0)
				return;

			if (((System.Windows.Forms.TabControl)sender).SelectedTab == null)
			{
				this._activeAntisera = 0;
			}
			else
			{
				this._activeAntisera = this.tabControl1.TabPages.IndexOf((TabPage)((System.Windows.Forms.TabControl)sender).SelectedTab);
				this.tabControl1.SelectedIndex = this._activeAntisera;
			}

			this.ActivateAntisera();
		}

		private void _dcTextKeyTrapCol_MouseClick(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Right)
			{
				if (this._dtAGT.Rows.Count > 0)
				{
					this.ContextMenu.Show(this, new Point(e.X, e.Y));
				}
			}
		}

		private void dgAntigenTyping_Enter(object sender, System.EventArgs e)
		{
			this.dgAntigenTyping.SetCurrentCell(0, 2);
		}

		private void dgAntigenTyping_Leave(object sender, System.EventArgs e)
		{
			for (int i=0 ; i<this._dtAGT.Rows.Count ; i++)
			{
				UpdateIndicator(i);
			}
		}

		private void dgAntigenTyping_LostFocus(object sender, EventArgs e)
		{
			if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
			{
				if (((VbecsGridEventArgs)e).TabKeyPressed)
				{
					this.SelectNextControl(this.dgAntigenTyping,true,true,false,false);
				}
			}
		}

		/// <summary>
		/// Checks if the reagent entered in the row has expired
		/// </summary>
		/// <param name="drLotNumber">Lot Number</param>
		private bool CheckForExpiredAntisera(System.Data.DataRow drLotNumber)
		{
			DateTime LotExpirationDate;
			DialogResult result = DialogResult.Yes;
			int row = this.dgAntigenTyping.CurrentCell.RowNumber;
			DateTime currentDate;

			currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			
			if (this._dtAGT.Rows.Count != 1)
			{
				if(drLotNumber.IsNull(TABLE.Reagent.LotExpirationDate) == false)
				{
					LotExpirationDate = System.Convert.ToDateTime(drLotNumber[TABLE.Reagent.LotExpirationDate]);
				}
				else
				{
					LotExpirationDate = DateTime.MaxValue;
				}

				if(LotExpirationDate >= currentDate)
				{
					if ( ((System.TimeSpan)(LotExpirationDate - currentDate)).Days < 1)
					{
						string sDlgMessage = "Antisera will expire at ";
						sDlgMessage += Common.VBECSDateTime.FormatDateTimeString(LotExpirationDate);
						sDlgMessage += ". ";
						sDlgMessage += "Continue to use?";
						result = MessageBox.Show(sDlgMessage, Common.StrRes.ValidMsg.UC041.AntiseraExpire().ResString, MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation);
				
						if (result != DialogResult.Yes)
						{
							return false;
						}
					}
					this._dtAGT.Rows[row][ARTIFICIAL.ReagentExpiredException] = DBNull.Value;
				}
				else
				{
					DlgOverrideComment dlg = new DlgOverrideComment("Expired Antiserum",Common.StrRes.Tooltips.UC041.ExpiredAntiserum(drLotNumber[TABLE.ReagentType.ReagentTypeName].ToString()).ResString,"PT");
					result = dlg.ShowDialog(this.FindForm());
					if (result != DialogResult.OK)
					{
						return false;
					}
					else
					{
						BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_antisera_used, dlg.Comment, Common.LogonUser.LogonUserName);
						exRep.GenerateExceptionQC((Guid)drLotNumber[TABLE.Reagent.ReagentGuid], Guid.Empty, Guid.Empty, (Guid)(this._dtAGT.Rows[row][TABLE.Patient.PatientGuid]), string.Empty, string.Empty, string.Empty, this.TestingTech);
						this._dtAGT.Rows[row][ARTIFICIAL.ReagentExpiredException] = exRep;
					}
				}
			}

			return true;
		}

		/// <summary>
		/// Checks the inspection indicator on the reagent
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <returns></returns>
		private bool CheckForSatisfactoryReagent(DataRow drLotNumber)
		{
			string sDlgMessage;

			if (this._dtAGT.Rows.Count != 1)
			{
				if ((bool)drLotNumber[TABLE.Reagent.InspectionIndicator] == false)
				{
					sDlgMessage = "Reagent (";
					sDlgMessage += drLotNumber[ARTIFICIAL.Manufacturer].ToString();
					sDlgMessage += " ";
					sDlgMessage += drLotNumber[ARTIFICIAL.Lot_Number].ToString();
					sDlgMessage += " ";
					sDlgMessage += drLotNumber[ARTIFICIAL.ExpirationDate].ToString();
					sDlgMessage += ") was recorded as Unsatisfactory during shipment receipt. You are not allowed to use this reagent.";

					MessageBox.Show(sDlgMessage, Common.StrRes.ValidMsg.UC041.AntigenTypingWeakD().ResString, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					return false;
				}
			}

			return true;
		}

		private void dgAntigenTyping_SizeChanged(object sender, EventArgs e)
		{
			if (this.dgAntigenTyping.TableStyles.Count>0)
			{
				DataGridTableStyle tblStyle = this.dgAntigenTyping.TableStyles[0];
				//
			    var dataGridColumnStyle = tblStyle.GridColumnStyles[ARTIFICIAL.Comment];
                //CR 3554
			    if (dataGridColumnStyle != null)
			        dataGridColumnStyle.Width = this.dgAntigenTyping.Width -
			                                                              (tblStyle.GridColumnStyles[ARTIFICIAL.Indicator].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.TestType].Width +
			                                                               tblStyle.GridColumnStyles[TABLE.Reagent.LotNumber].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.VialId].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.IS].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.RT].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.C37].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.AHG].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.CC].Width +
			                                                               tblStyle.GridColumnStyles[ARTIFICIAL.Interp].Width + 7);
			    this.cmbBoxComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.Comment].Width;
			}
		}
	}
}
